﻿using System;
using System.Windows;
using CustomerManager.CustomerProfileService;

namespace CustomerManager
{
  /// <summary>
  /// Logika interakcji z oknem EditCustomer.xaml.
  /// </summary>
  public partial class EditCustomer : Window
  {

    private CustomerProfileSoapClient _custProfile = 
      new CustomerProfileSoapClient();
      
    public EditCustomer(string customerId)
    {
      InitializeComponent();

      // Do zrobienia: sprawdzanie poprawności identyfikatora customerId.

      // Pobieranie obiektu klienta i wczytywanie kontrolek okna edycji.
      LoadControls(GetCustomer(customerId));

    }

    private Customer GetCustomer(string customerId)
    {
      return _custProfile.GetCustomer(customerId);
    }

    private void LoadControls(Customer customer)
    {
      textBoxAddress.Text = customer.Address;
      textBoxCity.Text = customer.City;
      textBoxCompany.Text = customer.CompanyName;
      textBoxFax.Text = customer.Fax;
      textBoxId.Text = customer.Id;
      textBoxName.Text = customer.Name;
      textBoxPhone.Text = customer.Phone;
      textBoxPostalCode.Text = customer.PostalCode;
      textBoxRegion.Text = customer.Region;
      textBoxTitle.Text = customer.Title;
    }


    private void buttonCancel_Click(object sender, RoutedEventArgs e)
    {
      this.Close();
    }

    private void buttonSave_Click(object sender, RoutedEventArgs e)
    {

      Customer cust = new Customer();

      cust.Address = textBoxAddress.Text;
      cust.City = textBoxCity.Text;
      cust.Title = textBoxTitle.Text;
      cust.Id = textBoxId.Text;
      cust.CompanyName = textBoxCompany.Text;
      cust.Fax = textBoxFax.Text;
      cust.Name = textBoxName.Text;
      cust.Phone = textBoxPhone.Text;
      cust.PostalCode = textBoxPostalCode.Text;
      cust.Region = textBoxRegion.Text;

      // Do zrobienia: dodać kraj do formularza.
      cust.Country = "nieznany";

      _custProfile.UpdateCustomer(cust);

      MessageBox.Show("Aktualizacja zakończyła się powodzeniem!");

      this.Close();

    }
  }
}
